/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.client.pi.PIHSCIOCIMClient;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.client.PIIOBusDataBean;
import com.ibm.hsc.client.PIIODrawerDataBean;
import com.ibm.hsc.client.PIIOSlotDataBean;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.HSCLogUtils;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class QueryParts {
    public static String[] LPAR_KEYS = new String[]{"name", "lpar_name", "lpar_id", "state", "curr_procs", "curr_proc_units", "curr_mem", "curr_proc_mode"};

    public static void partitionInfo(String string, String string2) throws PIHscClientException {
        PrintStream printStream = null;
        int n = 0;
        String string3 = CIMUtils._getHostName();
        try {
            printStream = string2 == null ? new PrintStream(new DataOutputStream(System.out)) : new PrintStream(new FileOutputStream(string2));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Throwable: " + throwable);
            HSCLogUtils.getErrMsg(throwable);
        }
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string3, "root/ibmhscS1_0");
        if (pIHSCClientObjectFactory == null) {
            return;
        }
        PIHSCCECClient pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string, true);
        if (pIHSCCECClient == null) {
            return;
        }
        Vector vector = pIHSCCECClient.getPartitionNames();
        for (int i = 0; i < vector.size(); ++i) {
            PILPARDataBean pILPARDataBean;
            UnsignedInt8 unsignedInt8;
            String[] stringArray = (String[])vector.elementAt(i);
            PIHSCLPARClient pIHSCLPARClient = pIHSCClientObjectFactory.createLPARClient(string, stringArray[0], true);
            if (pIHSCLPARClient == null || (unsignedInt8 = (pILPARDataBean = pIHSCLPARClient.getLPARDataBean(LPAR_KEYS)).getState()).intValue() != 1 && unsignedInt8.intValue() != 2) continue;
            ++n;
            printStream.print("Partition " + pILPARDataBean.getLparID());
            printStream.print(" named " + pILPARDataBean.getUserDefinedName());
            if (unsignedInt8.intValue() == 2) {
                printStream.println(" is running ");
            } else {
                printStream.println(" is booting ");
            }
            UnsignedInt8 unsignedInt82 = pILPARDataBean.getCurProcType();
            UnsignedInt16 unsignedInt16 = pILPARDataBean.getCurAllocProcs();
            UnsignedInt32 unsignedInt32 = pILPARDataBean.getCurAllocProcUnits();
            String string4 = PILPARProfileDataBean.getProcTypeString(unsignedInt82);
            String string5 = PIHMCCommandUtils.convertIntToFloatString(unsignedInt32);
            printStream.print("Processors " + string4 + " Allocated Processors " + unsignedInt16);
            if (pILPARDataBean.isProcModeShared()) {
                printStream.print(" Allocated Processor Units " + string5);
            }
            printStream.println();
            UnsignedInt32 unsignedInt322 = pILPARDataBean.getCurAllocMem();
            double d = unsignedInt322.doubleValue() / 1000.0;
            printStream.println("Memory Usage is " + d + " Gbytes");
            PIHSCIOCIMClient pIHSCIOCIMClient = pIHSCClientObjectFactory.createIOClient(string, null, null, null, stringArray, null, null, true);
            Hashtable hashtable = pIHSCIOCIMClient.getIODrawerDataBeanHash(true);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                boolean bl = false;
                PIIODrawerDataBean pIIODrawerDataBean = (PIIODrawerDataBean)enumeration.nextElement();
                Hashtable hashtable2 = pIIODrawerDataBean.getBuses();
                Enumeration enumeration2 = hashtable2.elements();
                while (enumeration2.hasMoreElements()) {
                    PIIOBusDataBean pIIOBusDataBean = (PIIOBusDataBean)enumeration2.nextElement();
                    Hashtable hashtable3 = pIIOBusDataBean.getSlots();
                    Enumeration enumeration3 = hashtable3.elements();
                    while (enumeration3.hasMoreElements()) {
                        String string6;
                        PIIOSlotDataBean pIIOSlotDataBean = (PIIOSlotDataBean)enumeration3.nextElement();
                        if (pIIOSlotDataBean.getPciVendorId().intValue() == 65535 && pIIOSlotDataBean.getPciDeviceId().intValue() == 65535) continue;
                        if (!bl) {
                            bl = true;
                            printStream.println("I/O Drawer " + pIIODrawerDataBean.getDrawerID());
                        }
                        if ((string6 = pIIOSlotDataBean.getLocation()) == null) {
                            string6 = "Unknown";
                        }
                        printStream.println("Slot " + string6 + " Class Code: " + pIIOSlotDataBean.getBestKnownDescription());
                    }
                }
            }
            printStream.println();
        }
        if (n == 0) {
            printStream.println("No Partitions running on this system");
            return;
        }
    }

    public static void main(String[] stringArray) throws PIHscClientException {
        String string = stringArray[0];
        String string2 = stringArray.length > 1 ? stringArray[1] : null;
        QueryParts.partitionInfo(string, string2);
    }
}

